<?php
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Load and decode the configuration file
    $config_data = json_decode(file_get_contents('template-config.json'), true);

    // Check for JSON decode errors
    if (json_last_error() !== JSON_ERROR_NONE) {
        die('Error decoding JSON: ' . json_last_error_msg());
    }

    // Retrieve allowed fields and title from config
    $allowed_fields = $config_data['allowed_fields'] ?? [];
    $title = $config_data['title'] ?? 'Form Submission';
    $custom_template_name = $config_data['custom_template_name'] ?? '';
    $template_name = $config_data['template_name'] ?? '';
    $site_url = str_replace("/process.php", "", "https://www.$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]");
    $errors = [];

    // Loop through the POST data and process
    foreach ($_POST as $key => $value) {
        if (in_array($key, $allowed_fields)) {
            // Handle specific fields
            if (is_array($value)) {
                $$key = implode(', ', $value);
            } else {
                $$key = htmlspecialchars(strip_tags($value ?? ''));
            }

            // Field-specific validation
            if ($key == 'phone' && !preg_match('/^\+?[0-9\s\-()]{7,15}$/', $value)) {
                $errors[] = "Invalid phone number.";
            }
            if ($key == 'email' && !filter_var($value, FILTER_VALIDATE_EMAIL)) {
                $errors[] = "Invalid email address.";
            }
        }
    }

    // If there are errors, redirect back with error messages
    if (!empty($errors)) {
        $error_message = urlencode(implode(' ', $errors));
        $referrer = $_SERVER['HTTP_REFERER'] ?? 'index.html';
        header("Location: $referrer?error=$error_message");
        exit();
    }

    // Initialize file uploads
    $uploads = [];

    // Check for image uploads and prepare them
    if (!empty($_FILES['images']['name'][0])) {
        foreach ($_FILES['images']['tmp_name'] as $key => $tmp_name) {
            $file_name = $_FILES['images']['name'][$key];
            $file_tmp = $_FILES['images']['tmp_name'][$key];
            $file_error = $_FILES['images']['error'][$key];

            // Check for upload errors
            if ($file_error === UPLOAD_ERR_OK) {
                $uploads[] = new CURLFile($file_tmp, mime_content_type($file_tmp), $file_name);
            }
        }
    }

    // Prepare data for cURL
    $data = [];
    foreach ($_POST as $key => $value) {
        if (in_array($key, $allowed_fields)) {
            $data[$key] = htmlspecialchars(strip_tags($value ?? ''));
        }
    }

    if( !empty($custom_template_name) ) {
        $data['custom_template_name'] = $custom_template_name;
    }
    if( !empty($template_name) ) {
        $data['template_name'] = $template_name;
    }
    if( !empty($site_url) ) {
        $data['site_url'] = $site_url;
    }

    // Add uploaded files to the data array for cURL
    if (!empty($uploads)) {
        foreach ($uploads as $key => $file) {
            $data['images[' . $key . ']'] = $file;
        }
    }

    // Initialize cURL
    $ch = curl_init('https://backend.miraclesitebuilder.co.uk/api/form-submission');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

    // Send the request
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    // Redirect to thank you page after successful submission
    header('Location: thank-you.html');
}
?>