document.getElementById('contact-form').addEventListener('submit', function(event) {
  event.preventDefault(); // Prevent the form from submitting normally

  var form = event.target;
  var submitButton = form.querySelector('button[type="submit"]'); // Get the submit button
  if( submitButton == null ) {
    submitButton = form.querySelector('input[type="submit"]');
  }
  submitButton.disabled = true; // Disable the submit button to prevent multiple submissions

  var formData = new FormData(form); // Create a FormData object from the form

  // Clear previous errors (if any)
  clearErrors();

  // Create an XMLHttpRequest object to handle the AJAX request
  var xhr = new XMLHttpRequest();

  // Open the request with the desired method and target URL
  xhr.open('POST', 'process.php', true);

  // Set up a callback function for when the request is complete
  xhr.onload = function() {
      if (xhr.status === 200) {
        try {
            var response = JSON.parse(xhr.responseText);

            // Check if the response status is success
            if (response.status === 'success') {
                // Handle successful response
                console.log('Form submitted successfully');
                console.log(response.message); // The success message from the server

                // Redirect to thank-you.html upon success
                window.location.href = 'thank-you.html'; // Or provide the absolute path if needed
            } else if (response.status === 'error' && response.errors) {
                // Handle validation errors returned from the server
                showErrors(response.errors);
            }
        } catch (error) {
            window.location.href = 'thank-you.html';
        }
          
      } else {
          // Handle other possible errors
          console.error('An error occurred: ' + xhr.status);
      }

      // Re-enable the submit button in case of error
      submitButton.disabled = false;
  };

  // Handle any potential error in the request
  xhr.onerror = function() {
      console.error('Request failed');
      submitButton.disabled = false; // Re-enable the button in case of network error
  };

  // Send the FormData with the file data and other form fields
  xhr.send(formData);
});

// Function to show error messages next to the form fields
function showErrors(errors) {
  for (var field in errors) {
      if (errors.hasOwnProperty(field)) {
          var inputElement = document.querySelector('[name="' + field + '"]');
          if (inputElement) {
              var errorElement = document.createElement('div');
              errorElement.className = 'error-message';
              errorElement.style.color = 'red';
              errorElement.textContent = errors[field].join(', '); // Join multiple errors with commas
              inputElement.parentNode.appendChild(errorElement);
          }
      }
  }
}

// Function to clear previous error messages
function clearErrors() {
  var errorMessages = document.querySelectorAll('.error-message');
  errorMessages.forEach(function(error) {
      error.remove();
  });
}