<?php
    /* ===== CONFIG ===== */
    $CLIENT_EMAILS = 'brightonpaintersuk@gmail.com';         // client email
    $ADMIN_EMAIL   = 'emails@miracleventures.co.uk';   // admin email
    $FROM_EMAIL    = 'emails@miracleventures.co.uk';   // sender email
    /* ================== */

    /* ==== SMS via ClickSend ==== */
    const CS_SMS_ENABLED = true;                                   // flip to false to disable SMS
    const CS_USERNAME    = 'emails@miracleventures.co.uk';         // ClickSend username (must be your ClickSend login email)
    const CS_API_KEY     = '6B5BEFC1-2FB1-E91F-B56F-BBBBB4C90017'; // ClickSend API key
    const CS_SENDER      = '';                                     // optional sender ID
    const CS_RECIPIENTS  = '+447525098073';                        // comma-separated list of mobiles in E.164 (+44...)
    /* =============================== */

    if ($_SERVER["REQUEST_METHOD"] === "POST") {
        $name  = htmlspecialchars($_POST["name"] ?? '');
        $phone = htmlspecialchars($_POST["phone"] ?? '');
        $email = htmlspecialchars($_POST["email"] ?? '');

        $subject = "Adwords New Lead" . $name;

        $url = $_SERVER['HTTP_REFERER'];

        // SMS on step 1
        $whoStart = $name ?: ($phone ?: ($email ?: 'Enquiry'));

        if (CS_SMS_ENABLED && CS_USERNAME !== '' && CS_API_KEY !== '') {
            $recipients = array_values(array_unique(array_filter(array_map('trim', explode(',', CS_RECIPIENTS)))));
            if (!empty($recipients)) {
                $smsBodyStart = "A new lead has started.\n\n"
                              . "Name: {$whoStart}\n"
                              . "Service: UPVC\n"
                              . ($email ? "Email: $email\n" : '')
                              . ($phone ? "Tel: $phone\n" : '');
                $smsResStart  = clicksend_send_sms_debug($recipients, $smsBodyStart);

                // Log result for debugging
                error_log("ClickSend SMS Result: " . print_r($smsResStart, true));
            }
        }

        // Headers
        $headers  = "From: Lead Surge Pro <".$FROM_EMAIL.">\r\n";
        $headers .= "Reply-To: ".$FROM_EMAIL."\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";

        // HTML email body
        $htmlContent = '
        <html>
        <head>
            <title>Lead Information So Far</title>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; }
                p { margin: 0; }
            </style>
        </head>
        <body>
            <div>
                <p>A new lead has started.</p><br/>
                <p><b>Name:</b> ' . $name . '</p>
                <p><b>Phone:</b> ' . $phone . '</p>';
                if (!empty($email)) {
                    $htmlContent .= '<p><b>Email:</b> ' . $email . '</p>';
                }
                $htmlContent .= '<p><b>Service:</b> UPVC LEAD</p><br />
                                 <p><b>URL:</b> '.$url.'</p>
            </div>
        </body>
        </html>';

        // Send to client
        $sendClient = mail($CLIENT_EMAILS, $subject, $htmlContent, $headers, "-f ".$FROM_EMAIL."");

        // Send to admin
        $sendAdmin  = mail($ADMIN_EMAIL, $subject, $htmlContent, $headers, "-f ".$FROM_EMAIL."");

        if ($sendClient && $sendAdmin) {
            echo json_encode([
                "success" => true,
                "message" => "Success! Your message has been sent.",
                "name"    => $name,
                "phone"   => $phone,
                "email"   => $email
            ]);
        } else {
            echo json_encode(["success" => false, "message" => "Error sending email"]);
        }
    } else {
        echo json_encode(["success" => false, "message" => "Invalid request"]);
    }

    /* ==============================
       Send SMS via ClickSend
    =============================== */
    function clicksend_send_sms_debug(array $numbers, string $body): array {
        $endpoint = 'https://rest.clicksend.com/v3/sms/send';
        $messages = [];
        foreach ($numbers as $to) {
            $msg = [
                'source' => 'php',
                'to'     => $to,
                'body'   => $body,
            ];
            if (CS_SENDER !== '') {
                $msg['from'] = CS_SENDER;
            }
            $messages[] = $msg;
        }

        $payload = json_encode(['messages' => $messages], JSON_UNESCAPED_UNICODE);

        $ch = curl_init($endpoint);
        curl_setopt_array($ch, [
            CURLOPT_POST           => true,
            CURLOPT_POSTFIELDS     => $payload,
            CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
            CURLOPT_USERPWD        => CS_USERNAME . ':' . CS_API_KEY, // Basic Auth
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT        => 20,
        ]);
        $resp = curl_exec($ch);
        $http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $err  = curl_error($ch);
        curl_close($ch);

        $ok = false;
        if ($http >= 200 && $http < 300) {
            $j = json_decode($resp, true);
            // ClickSend "SUCCESS" when queued
            $ok = isset($j['response_code']) && strtoupper($j['response_code']) === 'SUCCESS';
        }

        return [
            'ok'       => $ok,
            'http'     => $http,
            'resp'     => $resp,
            'curl_err' => $err
        ];
    }
?>
